from datetime import timedelta
import math

# This is per hour.
PRODUCTION_BY_LEVEL = [
	0,
	30,#1
	35,#2
	41,#3
	47,#4
	55,#5
	64,#6
	74,#7
	86,#8
	100,#9
	117,#10
	136,#11
	158,#12
	184,#13
	214,#14
	249,#15
	289,#16
	337,#17
	391,#18
	455,#19
	530,#20
	616,
	717,
	833,
	969,
	1127,
	1311,
	1525,
	1774,
	2063,
	2400]

capacity_by_type = {
	'spears':25,
	'swords':15,
	'axes':10,
	'bows':10,
	'lcav':80,
	'hcav':50,
	'bcav':50,
	'pal':100
	}

def get_production_time(level,stock,goal):
	"""Returns a formatted string with the time required to produce goal with
	stock to begin with in a building of level."""
	rate = PRODUCTION_BY_LEVEL[level]
	time = ((goal - stock) / rate) * 3600
	return str(timedelta(0,int(time+0.5)))

def calculator(text):
	"""Returns a string containing the result of the expression."""
	try:
		return str(eval(text))
	except:
		return 'Error'

def get_production_from_time(level,seconds):
	"""Returns a string containing the amount produced."""
	rate = PRODUCTION_BY_LEVEL[level] / 3600.0
	return str(rate * seconds)

def get_distance(start_x,start_y,stop_x,stop_y):
	return math.hypot(start_x-stop_x,start_y-stop_y)

def sort(rows,col):
	"""Sort rows by col. Maintain rows."""
	d = {}
	for row in rows:
		k = row[col]
		try:
			k = int(k)
			while k in d:
				k = k + 0.0001
		except:
			while k in d:
				k = k + '0'
		d[k] = row
	order = d.keys()
	order.sort()
	r = []
	for key in order:
		r.append(d[key])
	return r

