#!/usr/bin/env python
# -*- coding: utf-8 -*-
# generated by wxGlade 0.6.1 on Mon Mar 24 12:48:22 2008

import wx
import calcpart
# begin wxGlade: extracode
# end wxGlade


class Main(wx.Frame):
	def __init__(self, *args, **kwds):
		# begin wxGlade: Main.__init__
		kwds["style"] = wx.DEFAULT_FRAME_STYLE
		wx.Frame.__init__(self, *args, **kwds)
		self.notebook = wx.Notebook(self, -1, style=0)
		self.panel_farm = wx.Panel(self.notebook, -1)
		self.panel_production = wx.Panel(self.notebook, -1)
		self.panel_calc = wx.Panel(self.notebook, -1)
		self.panel_troops = wx.ScrolledWindow(self.notebook, -1, style=wx.TAB_TRAVERSAL)
		self.panel_res = wx.Panel(self.notebook, -1, style=wx.TAB_TRAVERSAL|wx.FULL_REPAINT_ON_RESIZE)
		self.blank_lbl = wx.StaticText(self.panel_res, -1, "")
		self.levels_lbl = wx.StaticText(self.panel_res, -1, "Levels")
		self.inv_lbl = wx.StaticText(self.panel_res, -1, "Stock")
		self.goal_lvl = wx.StaticText(self.panel_res, -1, "Final Stock")
		self.time_lbl = wx.StaticText(self.panel_res, -1, "Time")
		self.wood_lbl = wx.StaticText(self.panel_res, -1, "Wood")
		self.wood_level = wx.TextCtrl(self.panel_res, 0, "1")
		self.wood_stock = wx.TextCtrl(self.panel_res, 3, "")
		self.wood_final = wx.TextCtrl(self.panel_res, -1, "")
		self.wood_time = wx.TextCtrl(self.panel_res, -1, "")
		self.clay_lbl = wx.StaticText(self.panel_res, -1, "Clay")
		self.clay_level = wx.TextCtrl(self.panel_res, 1, "1")
		self.clay_stock = wx.TextCtrl(self.panel_res, 4, "")
		self.clay_final = wx.TextCtrl(self.panel_res, -1, "")
		self.clay_time = wx.TextCtrl(self.panel_res, -1, "")
		self.iron_lbl = wx.StaticText(self.panel_res, -1, "Iron")
		self.iron_level = wx.TextCtrl(self.panel_res, 2, "1")
		self.iron_stock = wx.TextCtrl(self.panel_res, 5, "")
		self.iron_final = wx.TextCtrl(self.panel_res, -1, "")
		self.iron_time = wx.TextCtrl(self.panel_res, -1, "")
		self.num_lbl = wx.StaticText(self.panel_troops, -1, "Number")
		self.total_lbl = wx.StaticText(self.panel_troops, -1, "Capacity")
		self.label_3 = wx.StaticText(self.panel_troops, -1, "Spears", style=wx.ALIGN_CENTRE)
		self.num_spears = wx.TextCtrl(self.panel_troops, -1, "")
		self.cap_spears = wx.TextCtrl(self.panel_troops, -1, "")
		self.label_4 = wx.StaticText(self.panel_troops, -1, "Swords", style=wx.ALIGN_CENTRE)
		self.num_swords = wx.TextCtrl(self.panel_troops, -1, "")
		self.cap_swords = wx.TextCtrl(self.panel_troops, -1, "")
		self.label_5 = wx.StaticText(self.panel_troops, -1, "Axes", style=wx.ALIGN_CENTRE)
		self.num_axes = wx.TextCtrl(self.panel_troops, -1, "")
		self.cap_axes = wx.TextCtrl(self.panel_troops, -1, "")
		self.label_6 = wx.StaticText(self.panel_troops, -1, "Bows", style=wx.ALIGN_CENTRE)
		self.num_bows = wx.TextCtrl(self.panel_troops, -1, "")
		self.cap_bows = wx.TextCtrl(self.panel_troops, -1, "")
		self.label_7 = wx.StaticText(self.panel_troops, -1, "Light Cav")
		self.num_lcav = wx.TextCtrl(self.panel_troops, -1, "")
		self.cap_lcav = wx.TextCtrl(self.panel_troops, -1, "")
		self.label_8 = wx.StaticText(self.panel_troops, -1, "Heavy Cav")
		self.num_hcav = wx.TextCtrl(self.panel_troops, -1, "")
		self.cap_hcav = wx.TextCtrl(self.panel_troops, -1, "")
		self.label_9 = wx.StaticText(self.panel_troops, -1, "Bow Cav")
		self.num_bcav = wx.TextCtrl(self.panel_troops, -1, "")
		self.cap_bcav = wx.TextCtrl(self.panel_troops, -1, "")
		self.label_10 = wx.StaticText(self.panel_troops, -1, "Paladin")
		self.num_pal = wx.TextCtrl(self.panel_troops, -1, "")
		self.cap_pal = wx.TextCtrl(self.panel_troops, -1, "")
		self.label_11 = wx.StaticText(self.panel_troops, -1, "Total")
		self.cap_total = wx.TextCtrl(self.panel_troops, -1, "")
		self.troop_clear_btn = wx.Button(self.panel_troops, wx.ID_CLEAR, "")
		self.calc0_lbl = wx.StaticText(self.panel_calc, -1, "Calculator 0")
		self.calc0_txt = wx.TextCtrl(self.panel_calc, -1, "0")
		self.calc0_result_txt = wx.TextCtrl(self.panel_calc, -1, "")
		self.calc1_lbl = wx.StaticText(self.panel_calc, -1, "Calculator 1")
		self.calc1_txt = wx.TextCtrl(self.panel_calc, -1, "0")
		self.calc1_result_txt = wx.TextCtrl(self.panel_calc, -1, "")
		self.calc2_lbl = wx.StaticText(self.panel_calc, -1, "Calculator 2")
		self.calc2_txt = wx.TextCtrl(self.panel_calc, -1, "0")
		self.calc2_result_txt = wx.TextCtrl(self.panel_calc, -1, "")
		self.calc3_lbl = wx.StaticText(self.panel_calc, -1, "Calculator 3")
		self.calc3_txt = wx.TextCtrl(self.panel_calc, -1, "0")
		self.calc3_result_txt = wx.TextCtrl(self.panel_calc, -1, "")
		self.calc4_lbl = wx.StaticText(self.panel_calc, -1, "Calculator 4")
		self.calc4_txt = wx.TextCtrl(self.panel_calc, -1, "0")
		self.calc4_result_txt = wx.TextCtrl(self.panel_calc, -1, "")
		self.label_2_copy = wx.StaticText(self.panel_production, -1, "")
		self.levels_lbl_2 = wx.StaticText(self.panel_production, -1, "Level")
		self.hours_lbl = wx.StaticText(self.panel_production, -1, "Hours")
		self.minutes_lbl = wx.StaticText(self.panel_production, -1, "Minutes")
		self.production_lbl = wx.StaticText(self.panel_production, -1, "Production")
		self.produce_lbl_wood = wx.StaticText(self.panel_production, -1, "Wood")
		self.production_level_wood = wx.TextCtrl(self.panel_production, -1, "1")
		self.production_hours_wood = wx.TextCtrl(self.panel_production, -1, "0")
		self.production_minutes_wood = wx.TextCtrl(self.panel_production, -1, "0")
		self.production_production_wood = wx.TextCtrl(self.panel_production, -1, "")
		self.produce_lbl_clay = wx.StaticText(self.panel_production, -1, "Clay")
		self.production_level_clay = wx.TextCtrl(self.panel_production, -1, "1")
		self.production_hours_clay = wx.TextCtrl(self.panel_production, -1, "0")
		self.production_minutes_clay = wx.TextCtrl(self.panel_production, -1, "0")
		self.production_production_clay = wx.TextCtrl(self.panel_production, -1, "")
		self.produce_lbl_iron = wx.StaticText(self.panel_production, -1, "Iron")
		self.production_level_iron = wx.TextCtrl(self.panel_production, -1, "1")
		self.production_hours_iron = wx.TextCtrl(self.panel_production, -1, "0")
		self.production_minutes_iron = wx.TextCtrl(self.panel_production, -1, "0")
		self.production_production_iron = wx.TextCtrl(self.panel_production, -1, "")
		self.x_lbl = wx.StaticText(self.panel_farm, -1, "X")
		self.y_lbl = wx.StaticText(self.panel_farm, -1, "Y")
		self.resources_lbl = wx.StaticText(self.panel_farm, -1, "Count")
		self.hour_lbl = wx.StaticText(self.panel_farm, -1, "Hour")
		self.min_lbl = wx.StaticText(self.panel_farm, -1, "Minute")
		self.month_lbl = wx.StaticText(self.panel_farm, -1, "Month")
		self.day_lbl = wx.StaticText(self.panel_farm, -1, "Day")
		self.x_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.y_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.count_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.hour_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.min_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.month_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.day_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.add_btn = wx.Button(self.panel_farm, wx.ID_ADD, "")
		self.del_btn = wx.Button(self.panel_farm, wx.ID_DELETE, "")
		self.farm_comment_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.origin_x_lbl = wx.StaticText(self.panel_farm, -1, "Origin X")
		self.origin_x_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.origin_y_lbl = wx.StaticText(self.panel_farm, -1, "Origin Y")
		self.origin_y_txt = wx.TextCtrl(self.panel_farm, -1, "", style=wx.TE_PROCESS_ENTER)
		self.farm_list = wx.ListBox(self.panel_farm, -1, choices=[], style=wx.LB_SINGLE|wx.LB_NEEDED_SB)

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, id=0)
		self.Bind(wx.EVT_TEXT, self.recalculate, id=0)
		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, id=3)
		self.Bind(wx.EVT_TEXT, self.recalculate, id=3)
		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, self.wood_final)
		self.Bind(wx.EVT_TEXT, self.recalculate, self.wood_final)
		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, id=1)
		self.Bind(wx.EVT_TEXT, self.recalculate, id=1)
		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, id=4)
		self.Bind(wx.EVT_TEXT, self.recalculate, id=4)
		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, self.clay_final)
		self.Bind(wx.EVT_TEXT, self.recalculate, self.clay_final)
		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, id=2)
		self.Bind(wx.EVT_TEXT, self.recalculate, id=2)
		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, id=5)
		self.Bind(wx.EVT_TEXT, self.recalculate, id=5)
		self.Bind(wx.EVT_TEXT_ENTER, self.recalculate, self.iron_final)
		self.Bind(wx.EVT_TEXT, self.recalculate, self.iron_final)
		self.Bind(wx.EVT_TEXT_ENTER, self.capacity, self.num_spears)
		self.Bind(wx.EVT_TEXT, self.capacity, self.num_spears)
		self.Bind(wx.EVT_TEXT_ENTER, self.capacity, self.num_swords)
		self.Bind(wx.EVT_TEXT, self.capacity, self.num_swords)
		self.Bind(wx.EVT_TEXT_ENTER, self.capacity, self.num_axes)
		self.Bind(wx.EVT_TEXT, self.capacity, self.num_axes)
		self.Bind(wx.EVT_TEXT_ENTER, self.capacity, self.num_bows)
		self.Bind(wx.EVT_TEXT, self.capacity, self.num_bows)
		self.Bind(wx.EVT_TEXT_ENTER, self.capacity, self.num_lcav)
		self.Bind(wx.EVT_TEXT, self.capacity, self.num_lcav)
		self.Bind(wx.EVT_TEXT_ENTER, self.capacity, self.num_hcav)
		self.Bind(wx.EVT_TEXT, self.capacity, self.num_hcav)
		self.Bind(wx.EVT_TEXT_ENTER, self.capacity, self.num_bcav)
		self.Bind(wx.EVT_TEXT, self.capacity, self.num_bcav)
		self.Bind(wx.EVT_TEXT_ENTER, self.capacity, self.num_pal)
		self.Bind(wx.EVT_TEXT, self.capacity, self.num_pal)
		self.Bind(wx.EVT_BUTTON, self.troop_clear, self.troop_clear_btn)
		self.Bind(wx.EVT_TEXT_ENTER, self.calculator0, self.calc0_txt)
		self.Bind(wx.EVT_TEXT, self.calculator0, self.calc0_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.calculator1, self.calc1_txt)
		self.Bind(wx.EVT_TEXT, self.calculator1, self.calc1_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.calculator2, self.calc2_txt)
		self.Bind(wx.EVT_TEXT, self.calculator2, self.calc2_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.calculator3, self.calc3_txt)
		self.Bind(wx.EVT_TEXT, self.calculator3, self.calc3_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.calculator4, self.calc4_txt)
		self.Bind(wx.EVT_TEXT, self.calculator4, self.calc4_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_level_wood)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_level_wood)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_hours_wood)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_hours_wood)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_minutes_wood)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_minutes_wood)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_level_clay)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_level_clay)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_hours_clay)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_hours_clay)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_minutes_clay)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_minutes_clay)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_level_iron)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_level_iron)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_hours_iron)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_hours_iron)
		self.Bind(wx.EVT_TEXT_ENTER, self.producer, self.production_minutes_iron)
		self.Bind(wx.EVT_TEXT, self.producer, self.production_minutes_iron)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.x_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.y_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.count_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.hour_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.min_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.month_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.day_txt)
		self.Bind(wx.EVT_BUTTON, self.farm_add, self.add_btn)
		self.Bind(wx.EVT_BUTTON, self.farm_delete, self.del_btn)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.farm_comment_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.origin_x_txt)
		self.Bind(wx.EVT_TEXT_ENTER, self.farm_add, self.origin_y_txt)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: Main.__set_properties
		self.SetTitle("Tribal Wars Calculator")
		self.wood_time.Enable(False)
		self.clay_time.Enable(False)
		self.iron_time.Enable(False)
		self.cap_spears.Enable(False)
		self.cap_swords.Enable(False)
		self.cap_axes.Enable(False)
		self.cap_bows.Enable(False)
		self.cap_lcav.Enable(False)
		self.cap_hcav.Enable(False)
		self.cap_bcav.Enable(False)
		self.cap_pal.Enable(False)
		self.cap_total.Enable(False)
		self.panel_troops.SetScrollRate(10, 10)
		self.calc0_result_txt.Enable(False)
		self.calc1_result_txt.Enable(False)
		self.calc2_result_txt.Enable(False)
		self.calc3_result_txt.Enable(False)
		self.calc4_result_txt.Enable(False)
		self.production_production_wood.Enable(False)
		self.production_production_clay.Enable(False)
		self.production_production_iron.Enable(False)
		self.add_btn.SetDefault()
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: Main.__do_layout
		sizer_big = wx.BoxSizer(wx.VERTICAL)
		sizer_farm = wx.BoxSizer(wx.VERTICAL)
		farm_entry_grid = wx.FlexGridSizer(2, 7, 1, 1)
		grid_prod = wx.FlexGridSizer(4, 5, 1, 1)
		grid_calc = wx.FlexGridSizer(5, 3, 1, 1)
		grid_troops = wx.FlexGridSizer(10, 3, 1, 1)
		grid_res = wx.FlexGridSizer(4, 5, 1, 1)
		grid_res.Add(self.blank_lbl, 0, wx.LEFT|wx.TOP|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.levels_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.inv_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.goal_lvl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.time_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.wood_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.wood_level, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.wood_stock, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.wood_final, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.wood_time, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.clay_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.clay_level, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.clay_stock, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.clay_final, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.clay_time, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.iron_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.iron_level, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.iron_stock, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.iron_final, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_res.Add(self.iron_time, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		self.panel_res.SetSizer(grid_res)
		grid_res.AddGrowableCol(1)
		grid_res.AddGrowableCol(2)
		grid_res.AddGrowableCol(3)
		grid_res.AddGrowableCol(4)
		grid_troops.Add((1, 1), 0, wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_lbl, 0, wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.total_lbl, 0, wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_3, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_spears, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_spears, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_4, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_swords, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_swords, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_5, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_axes, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_axes, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_6, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_bows, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_bows, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_7, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_lcav, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_lcav, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_8, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_hcav, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_hcav, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_9, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_bcav, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_bcav, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_10, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.num_pal, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_pal, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.label_11, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add((1, 1), 0, wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.cap_total, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_troops.Add((1, 1), 0, wx.ADJUST_MINSIZE, 0)
		grid_troops.Add(self.troop_clear_btn, 0, wx.ADJUST_MINSIZE, 0)
		self.panel_troops.SetSizer(grid_troops)
		grid_troops.AddGrowableCol(1)
		grid_troops.AddGrowableCol(2)
		grid_calc.Add(self.calc0_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc0_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc0_result_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc1_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc1_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc1_result_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc2_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc2_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc2_result_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc3_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc3_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc3_result_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc4_lbl, 0, wx.LEFT|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc4_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_calc.Add(self.calc4_result_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		self.panel_calc.SetSizer(grid_calc)
		grid_calc.AddGrowableCol(1)
		grid_calc.AddGrowableCol(2)
		grid_calc.AddGrowableCol(3)
		grid_calc.AddGrowableCol(4)
		grid_prod.Add(self.label_2_copy, 0, wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.levels_lbl_2, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.hours_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.minutes_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.produce_lbl_wood, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_level_wood, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_hours_wood, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_minutes_wood, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_production_wood, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.produce_lbl_clay, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_level_clay, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_hours_clay, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_minutes_clay, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_production_clay, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.produce_lbl_iron, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_level_iron, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_hours_iron, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_minutes_iron, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		grid_prod.Add(self.production_production_iron, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		self.panel_production.SetSizer(grid_prod)
		grid_prod.AddGrowableCol(1)
		grid_prod.AddGrowableCol(2)
		grid_prod.AddGrowableCol(3)
		grid_prod.AddGrowableCol(4)
		farm_entry_grid.Add(self.x_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.y_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.resources_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.hour_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.min_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.month_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.day_lbl, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.x_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.y_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.count_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.hour_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.min_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.month_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.day_txt, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.add_btn, 0, wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.del_btn, 0, wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.farm_comment_txt, 0, wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.origin_x_lbl, 0, wx.ALIGN_RIGHT|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.origin_x_txt, 0, wx.ALIGN_RIGHT|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.origin_y_lbl, 0, wx.ALIGN_RIGHT|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.Add(self.origin_y_txt, 0, wx.ALIGN_RIGHT|wx.ADJUST_MINSIZE, 0)
		farm_entry_grid.AddGrowableRow(2)
		farm_entry_grid.AddGrowableCol(0)
		farm_entry_grid.AddGrowableCol(1)
		farm_entry_grid.AddGrowableCol(2)
		farm_entry_grid.AddGrowableCol(3)
		farm_entry_grid.AddGrowableCol(4)
		farm_entry_grid.AddGrowableCol(5)
		farm_entry_grid.AddGrowableCol(6)
		sizer_farm.Add(farm_entry_grid, 1, wx.EXPAND, 0)
		sizer_farm.Add(self.farm_list, 3, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		self.panel_farm.SetSizer(sizer_farm)
		self.notebook.AddPage(self.panel_res, "Resources")
		self.notebook.AddPage(self.panel_troops, "Troops")
		self.notebook.AddPage(self.panel_calc, "Calculator")
		self.notebook.AddPage(self.panel_production, "Production")
		self.notebook.AddPage(self.panel_farm, "Farm Log")
		sizer_big.Add(self.notebook, 1, wx.EXPAND, 0)
		self.SetSizer(sizer_big)
		sizer_big.Fit(self)
		self.Layout()
		# end wxGlade

	def recalculate(self, event): # wxGlade: Main.<event_handler>
		"""This is for the Resources tab. Its name is from back when it was the only thing
		this program did."""
		LEVEL = 0
		STOCK = 1
		FINAL = 2
		TIME = 3
		for resource in [(self.wood_level,self.wood_stock,self.wood_final,self.wood_time),
						 (self.clay_level,self.clay_stock,self.clay_final,self.clay_time),
						 (self.iron_level,self.iron_stock,self.iron_final,self.iron_time)#,
						 ]:
			try:
				level = int(resource[LEVEL].GetValue())
				stock = float(resource[STOCK].GetValue())
				goal = float(resource[FINAL].GetValue())
				time = calcpart.get_production_time(level,stock,goal)
				resource[TIME].SetValue(time)
			except Exception,msg:
				resource[TIME].SetValue("Invalid")

	def producer(self, event): # wxGlade: Main.<event_handler>
		LEVEL = 0
		HOURS = 1
		MINUTES = 2
		PRODUCTION = 3
		for resource in [(self.production_level_wood,self.production_hours_wood,self.production_minutes_wood,self.production_production_wood),
						 (self.production_level_clay,self.production_hours_clay,self.production_minutes_clay,self.production_production_clay),
						 (self.production_level_iron,self.production_hours_iron,self.production_minutes_iron,self.production_production_iron)
						 ]:
			try:
				level = int(resource[LEVEL].GetValue())
				hours = float(resource[HOURS].GetValue())
				minutes = float(resource[MINUTES].GetValue())
				seconds = 3600*hours + 60*minutes
				production = calcpart.get_production_from_time(level,seconds)
				resource[PRODUCTION].SetValue(production)
			except Exception,msg:
				resource[PRODUCTION].SetValue('Invalid')

	def capacity(self, event): # wxGlade: Main.<event_handler>
		# Calculate capacity for each field in capacity panel
		total = 0
		for kind in ['spears','swords','axes','bows','lcav','hcav','bcav','pal']:
			cap_field = eval('self.cap_'+kind)
			num_field = eval('self.num_'+kind)
			capacity = calcpart.capacity_by_type[kind]
			try:
				total_cap = capacity * int(num_field.GetValue())
			except ValueError:
				total_cap = 0
			cap_field.SetValue(str(total_cap))
			total += total_cap
		self.cap_total.SetValue(str(total))

	def troop_clear(self, event): # wxGlade: Main.<event_handler>
		for kind in ['spears','swords','axes','bows','lcav','hcav','bcav','pal']:
			num_field = eval('self.num_'+kind)
			num_field.SetValue('')
		#self.capacity(None)
		
	def calculator0(self, event): # wxGlade: Main.<event_handler>
		self.calc0_result_txt.SetValue(calcpart.calculator(self.calc0_txt.GetValue()))

	def calculator1(self, event): # wxGlade: Main.<event_handler>
		self.calc1_result_txt.SetValue(calcpart.calculator(self.calc1_txt.GetValue()))

	def calculator2(self, event): # wxGlade: Main.<event_handler>
		self.calc2_result_txt.SetValue(calcpart.calculator(self.calc2_txt.GetValue()))

	def calculator3(self, event): # wxGlade: Main.<event_handler>
		self.calc3_result_txt.SetValue(calcpart.calculator(self.calc3_txt.GetValue()))

	def calculator4(self, event): # wxGlade: Main.<event_handler>
		self.calc4_result_txt.SetValue(calcpart.calculator(self.calc4_txt.GetValue()))

	def farm_add(self, event): # wxGlade: Main.<event_handler>
		comment = self.farm_comment_txt.GetValue()
		self.farm_comment_txt.SetValue('')
		if comment:
			comment = "("+comment+")"
		x = self.x_txt.GetValue()
		y = self.y_txt.GetValue()
		count = self.count_txt.GetValue()
		try:
			count = eval(count)
		except:
			pass
		hour = self.hour_txt.GetValue()
		minute = self.min_txt.GetValue()
		month = self.month_txt.GetValue()
		day = self.day_txt.GetValue()
		try:
			o_x = int(self.origin_x_txt.GetValue())
			o_y = int(self.origin_y_txt.GetValue())
			
			d = calcpart.get_distance(o_x,o_y,int(x),int(y))
			d = ' d:'+str(round(d,3))
		except ValueError:
			d = ''
		s = '(%s|%s)%s:%s @ %s:%s %s/%s'%(x,y,comment,count,hour,minute,month,day)
		self.farm_list.InsertItems([s+d],-1)
		self.x_txt.SetFocus()
		self.x_txt.SelectAll()
		
	def farm_delete(self, event): # wxGlade: Main.<event_handler>
		sel = self.farm_list.GetSelections()
		if sel:
			self.farm_list.Delete(sel[0])

# end of class Main


class CalculatorFrame(wx.Frame):
	def __init__(self, *args, **kwds):
		# content of this block not found: did you rename this class?
		pass

	def __set_properties(self):
		# content of this block not found: did you rename this class?
		pass

	def __do_layout(self):
		# content of this block not found: did you rename this class?
		pass

# end of class CalculatorFrame

class Calculator(wx.App):
	def OnInit(self):
		wx.InitAllImageHandlers()
		frame_main = Main(None, -1, "")
		self.SetTopWindow(frame_main)
		frame_main.Show()
		return 1

# end of class Calculator

if __name__ == "__main__":
	TribalCalculator = Calculator(0)
	TribalCalculator.MainLoop()
